/*
 *
 * System5x7
 *
 *
 * File Name           : System5x7.h
 * Date                : 28 Oct 2008
 * Font size in bytes  : 470
 * Font width          : 5
 * Font height         : 7
 * Font first char     : 32
 * Font last char      : 127
 * Font used chars     : 94
 *
 * The font data are defined as
 *
 * struct _FONT_ {
 *     uint16_t   font_Size_in_Bytes_over_all_included_Size_it_self;
 *     uint8_t    font_Width_in_Pixel_for_fixed_drawing;
 *     uint8_t    font_Height_in_Pixel_for_all_characters;
 *     unit8_t    font_First_Char;
 *     uint8_t    font_Char_Count;
 *
 *     uint8_t    font_Char_Widths[font_Last_Char - font_First_Char +1];
 *                  // for each character the separate width in pixels,
 *                  // characters < 128 have an implicit virtual right empty row
 *
 *     uint8_t    font_data[];
 *                  // bit field of all characters
 */

#include <inttypes.h>
#include <avr/pgmspace.h>

#ifndef System_Mid5x7_H
#define System_Mid5x7_H

#define System_Mid5x7_WIDTH 5
#define System_Mid5x7_HEIGHT 7

/*
 * added to allow fontname to match header file name. 
 * as well as keep the old name for backward compability
 */

#define System_Mid5x7  System_Mid5x7

const static uint8_t System_Mid5x7[] PROGMEM = {
    0x0, 0x0, // size of zero indicates fixed width font, actual length is width * height
    0x05, // width
    0x07, // height
    0x20, // first char
    0x60, // char count
    
    // Fixed width; char width table not used !!!!
    
    // font data
		0x00, 0x00, 0x00, 0x00, 0x00,            // Code for char  
        0x00, 0x00, 0xBE, 0x00, 0x00,            // Code for char !
        0x00, 0x06, 0x00, 0x06, 0x00,            // Code for char "
        0x28, 0xFE, 0x28, 0xFE, 0x28,            // Code for char #
        0x48, 0x54, 0xFE, 0x54, 0x24,            // Code for char $
        0x46, 0x26, 0x10, 0xC8, 0xC4,            // Code for char %
        0x6C, 0x92, 0x6A, 0x64, 0x90,            // Code for char &
        0x00, 0x00, 0x06, 0x00, 0x00,            // Code for char '
        0x7C, 0x82, 0x00, 0x00, 0x00,            // Code for char (
        0x00, 0x00, 0x00, 0x82, 0x7C,            // Code for char )
        0x00, 0x0A, 0x04, 0x0A, 0x00,            // Code for char *
        0x10, 0x10, 0x7C, 0x10, 0x10,            // Code for char +
        0x00, 0xA0, 0x60, 0x00, 0x00,            // Code for char ,
        0x10, 0x10, 0x10, 0x10, 0x10,            // Code for char -
        0x00, 0xC0, 0xC0, 0x00, 0x00,            // Code for char .
        0x40, 0x20, 0x10, 0x08, 0x04,            // Code for char /
        0x7C, 0xFE, 0x92, 0x8A, 0x7C,            // Code for char 0
        0x00, 0x84, 0xFE, 0xFE, 0x80,            // Code for char 1
        0xE2, 0xF2, 0x92, 0x9E, 0x8C,            // Code for char 2
        0x82, 0x92, 0x92, 0xFE, 0x6C,            // Code for char 3
        0x78, 0x44, 0xFE, 0xFE, 0x40,            // Code for char 4
        0x8E, 0x8E, 0x8A, 0xFA, 0x72,            // Code for char 5
        0x7C, 0xFE, 0x8A, 0x8A, 0x72,            // Code for char 6
        0x02, 0xE2, 0xF2, 0x1A, 0x0E,            // Code for char 7
        0x6C, 0xFE, 0x92, 0x92, 0x6C,            // Code for char 8
        0x9C, 0xA2, 0xA2, 0xFE, 0x7C,            // Code for char 9
        0x00, 0x00, 0x6C, 0x6C, 0x00,            // Code for char :
        0x00, 0x00, 0xAC, 0x6C, 0x00,            // Code for char ;
        0x10, 0x28, 0x44, 0x82, 0x00,            // Code for char <
        0x28, 0x28, 0x28, 0x28, 0x28,            // Code for char =
        0x00, 0x82, 0x44, 0x28, 0x10,            // Code for char >
        0x04, 0x02, 0xA2, 0x12, 0x0C,            // Code for char ?
        0x0C, 0x9A, 0x9A, 0x82, 0x7C,            // Code for char @
        0xFC, 0x12, 0x12, 0x12, 0xFC,            // Code for char A
        0xFE, 0x92, 0x92, 0x92, 0x6C,            // Code for char B
        0x7C, 0x82, 0x82, 0x82, 0x44,            // Code for char C
        0xFE, 0x82, 0x82, 0x82, 0x7C,            // Code for char D
        0xFE, 0x92, 0x92, 0x92, 0x82,            // Code for char E
        0xFE, 0x12, 0x12, 0x12, 0x02,            // Code for char F
        0x7C, 0x82, 0x92, 0x92, 0x74,            // Code for char G
        0xFE, 0x10, 0x10, 0x10, 0xFE,            // Code for char H
        0x00, 0x82, 0xFE, 0x82, 0x00,            // Code for char I
        0x40, 0x80, 0x80, 0x82, 0x7E,            // Code for char J
        0xFE, 0x10, 0x28, 0x44, 0x82,            // Code for char K
        0xFE, 0x80, 0x80, 0x80, 0x80,            // Code for char L
        0xFE, 0x04, 0x08, 0x04, 0xFE,            // Code for char M
        0xFE, 0x04, 0x08, 0x10, 0xFE,            // Code for char N
        0x7C, 0x82, 0x82, 0x82, 0x7C,            // Code for char O
        0xFE, 0x12, 0x12, 0x12, 0x0C,            // Code for char P
        0x7C, 0x82, 0xA2, 0x42, 0xBC,            // Code for char Q
        0xFE, 0x12, 0x32, 0x52, 0x8C,            // Code for char R
        0x4C, 0x92, 0x92, 0x92, 0x64,            // Code for char S
        0x02, 0x02, 0xFE, 0x02, 0x02,            // Code for char T
        0x7E, 0x80, 0x80, 0x80, 0x7E,            // Code for char U
        0x3E, 0x40, 0x80, 0x40, 0x3E,            // Code for char V
        0x7E, 0x80, 0x60, 0x80, 0x7E,            // Code for char W
        0xC6, 0x28, 0x10, 0x28, 0xC6,            // Code for char X
        0x0E, 0x10, 0xE0, 0x10, 0x0E,            // Code for char Y
        0xC2, 0xA2, 0x92, 0x8A, 0x86,            // Code for char Z
        0xFE, 0x82, 0x82, 0x00, 0x00,            // Code for char [
        0x04, 0x08, 0x10, 0x20, 0x40,            // Code for char BackSlash
        0x00, 0x00, 0x82, 0x82, 0xFE,            // Code for char ]
        0x08, 0x04, 0x02, 0x04, 0x08,            // Code for char ^
        0x80, 0x80, 0x80, 0x80, 0x80,            // Code for char _
        0x00, 0x00, 0x02, 0x04, 0x00,            // Code for char `
        0x40, 0xA8, 0xA8, 0xA8, 0xF0,            // Code for char a
        0xFE, 0x90, 0x88, 0x88, 0x70,            // Code for char b
        0x70, 0x88, 0x88, 0x88, 0x50,            // Code for char c
        0x70, 0x88, 0x88, 0x90, 0xFE,            // Code for char d
        0x70, 0xA8, 0xA8, 0xA8, 0x30,            // Code for char e
        0x00, 0x10, 0xF8, 0x14, 0x14,            // Code for char f
        0x10, 0xA8, 0xA8, 0xA8, 0x78,            // Code for char g
        0xFE, 0x10, 0x08, 0x08, 0xF0,            // Code for char h
        0x00, 0x88, 0xFA, 0x80, 0x00,            // Code for char i
        0x40, 0x80, 0x80, 0x88, 0x7A,            // Code for char j
        0xFE, 0x20, 0x50, 0x88, 0x00,            // Code for char k
        0x00, 0x00, 0xFE, 0x00, 0x00,            // Code for char l
        0xF8, 0x08, 0xF0, 0x08, 0xF0,            // Code for char m
        0xF8, 0x10, 0x08, 0x08, 0xF0,            // Code for char n
        0x70, 0x88, 0x88, 0x88, 0x70,            // Code for char o
        0xF8, 0x28, 0x28, 0x28, 0x10,            // Code for char p
        0x10, 0x28, 0x28, 0xF8, 0x80,            // Code for char q
        0xF8, 0x10, 0x08, 0x08, 0x10,            // Code for char r
        0x90, 0xA8, 0xA8, 0xA8, 0x48,            // Code for char s
        0x00, 0x10, 0x7C, 0x90, 0x00,            // Code for char t
        0x78, 0x80, 0x80, 0x40, 0xF8,            // Code for char u
        0x38, 0x40, 0x80, 0x40, 0x38,            // Code for char v
        0x78, 0x80, 0x60, 0x80, 0x78,            // Code for char w
        0x88, 0x50, 0x20, 0x50, 0x88,            // Code for char x
        0x18, 0xA0, 0xA0, 0xA0, 0x78,            // Code for char y
        0x88, 0xC8, 0xA8, 0x98, 0x88,            // Code for char z
        0x10, 0x6C, 0x82, 0x00, 0x00,            // Code for char {
        0x00, 0x00, 0xFE, 0x00, 0x00,            // Code for char |
        0x00, 0x00, 0x82, 0x6C, 0x10,            // Code for char }
        0x80, 0x40, 0x40, 0x80, 0x40             // Code for char ~
        };
#endif
